unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    Label2: TLabel;
    Edit2: TEdit;
    ListBox1: TListBox;
    procedure Button1Click(Sender: TObject);
  private
    procedure ProcuraPalavra(Arquivo, Palavra: String);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ProcuraPalavra(Arquivo, Palavra : String);
var
  i : Integer;
  Buffer : String;
  F : TextFile;
begin
// testa a existncia do arquivo
  if not FileExists(Arquivo) then
    raise Exception.Create('Arquivo inexistente');
// abre o arquivo
  AssignFile(F,Arquivo);
// inicializa para leitura
  Reset(F);
  i := 0;
  while not EOF(F) do begin
    Inc(i);
// l a linha
    ReadLn(F,Buffer);
// procura se a palavra est na linha
    if Pos(Palavra,Buffer) <> 0 then
      Listbox1.Items.Add('Linha '+IntToStr(i)+
         ': '+Buffer);
  end;
  CloseFile(F);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Listbox1.Clear;
  if (Edit1.Text <> '') and (Edit2.Text <> '') then
    ProcuraPalavra(Edit1.Text,Edit2.Text);
end;

end.
